#include <amxmodx>
#include <fakemeta>

#define PLUGIN "Console Icon"
#define VERSION "1.1"
#define AUTHOR "DJ_WEST"

#define MAX_PLAYERS 32
#define ICON_TASKID 8912

new g_Sprite, bool:g_b_InConsole[MAX_PLAYERS+1], bool:g_b_Connected[MAX_PLAYERS+1]

public plugin_init() 
{
	register_plugin(PLUGIN, VERSION, AUTHOR)
	
	register_clcmd("showconsole", "Show_Console")
	register_event("HLTV", "New_Round", "a", "1=0", "2=0")
	register_forward(FM_CmdStart, "Cmd_Start")
}

public plugin_precache()
	g_Sprite = precache_model("sprites/console_icon.spr")

public Cmd_Start(id, uc_handle, random_seed)
{
	if (g_b_InConsole[id])
	{
		new i_Button
		i_Button = get_uc(uc_handle, UC_Buttons)
	    
		if (i_Button > 0)
		{	
			g_b_InConsole[id] = false
			remove_task(id + ICON_TASKID)
			Remove_Icon(id)
		}
	}
}

public client_putinserver(id)
{
	g_b_Connected[id] = true
	g_b_InConsole[id] = false
	set_task(5.0, "Bind_Console", id)
}
	
public New_Round()
{
	for (new id = 1; id <= MAX_PLAYERS; id++)
		Bind_Console(id)
}

public Show_Console(id)
{
	if (!is_user_alive(id))
		return PLUGIN_HANDLED
		
	if (g_b_InConsole[id])
	{
		g_b_InConsole[id] = false
		remove_task(id + ICON_TASKID)
		Remove_Icon(id)
		
		return PLUGIN_HANDLED
	}
	
	g_b_InConsole[id] = true
	Show_Icon(id + ICON_TASKID)
	set_task(10.0, "Show_Icon", id + ICON_TASKID, _, _, "b")
	
	return PLUGIN_HANDLED
}

public Bind_Console(id)
{
	if (g_b_Connected[id])
		client_cmd(id, "bind ` ^"showconsole;toggleconsole^"")
}

public Show_Icon(taskid)
{
	new id
	id = taskid - ICON_TASKID
	
	message_begin(MSG_ALL, SVC_TEMPENTITY)
	write_byte(TE_PLAYERATTACHMENT)
	write_byte(id)
	write_coord(50)
	write_short(g_Sprite)
	write_short(100)
	message_end()
}

public Remove_Icon(id)
{
	message_begin(MSG_ALL, SVC_TEMPENTITY)
	write_byte(TE_KILLPLAYERATTACHMENTS)
	write_byte(id)
	message_end()	
}

public client_disconnect(id)
{
	g_b_Connected[id] = false
	g_b_InConsole[id] = false
	remove_task(id + ICON_TASKID)
}
